#include <stdlib.h>
#include "SDL/SDL.h"
#include "SDL/SDL_mixer.h"
#include <math.h>
#include "SDL/SDL_image.h"
#include "SDL/SDL_ttf.h"
#include "string.h"

//Umgebungsvariablen
SDL_Surface *screen = NULL;
SDL_Surface *rahmen = NULL;
SDL_Surface *message = NULL;
SDL_Surface *scrolltext = NULL;
const int HOEHE = 640;
const int BREITE = 480;
const int FARBTIEFE = 32;

TTF_Font *font;
SDL_Color txt = {0,0,0};

 int main( int argc, char* args[] )
 {
     //window initialisieren
     //Start SDL
     SDL_Init(SDL_INIT_EVERYTHING);
     // Inilialize SDL_mixer , exit if fail
     if( SDL_Init(SDL_INIT_AUDIO) < 0 ) exit(1);
     //Bildschirm
     screen = SDL_SetVideoMode(HOEHE, BREITE, FARBTIEFE, SDL_NOFRAME| SDL_DOUBLEBUF);//|SDL_FULLSCREEN);

     if(screen == NULL)
     {
         fprintf(stderr, "Bildschirm konnte nicht initialisiert werden: %s", SDL_GetError());
         exit(1);
     }

     //Titel der Applikation in der Taskleiste oder im Windowsleiste
     SDL_WM_SetCaption("XMAS_demo ", NULL);
     SDL_ShowCursor(0);

     //Initialize Musix
     int flags=MIX_INIT_MOD;
     int initted=Mix_Init(flags);
     if(initted&&flags != flags)
     {
                      printf("Mix_Init: Failed to init required ogg and mod support!\n");
                      printf("Mix_Init: %s\n", Mix_GetError());
    }

    //Audio ffnen
    if(Mix_OpenAudio(44100, MIX_DEFAULT_FORMAT, 2, 4096)==-1) {
    printf("Mix_OpenAudio: %s\n", Mix_GetError());
    exit(2);
    }

    //Lade musix
    Mix_Music * music = Mix_LoadMUS("xmas.mod");
if(!music){
    printf("MUSIC_load: %s\n", Mix_GetError());
}

// play music forever
if(Mix_PlayMusic(music, -1)==-1) printf("Mix_PlayMusic: %s\n", Mix_GetError());

     if(TTF_Init() < 0){exit(1);}

//rendering images
           rahmen = IMG_Load("rahmen.png");
           rahmen = SDL_DisplayFormat(rahmen);

           SDL_Rect offset;
           offset.x = 110;
           offset.y = 150;
           SDL_Rect offsetter;
           offsetter.x = 15;
           offsetter.y = 85;

font = TTF_OpenFont("PC_Snowballs.ttf", 50);
char *ubertext = "Happy XMAS";
char *blogtext = "                    Ich wuensch euch froehliche Weihnachten und einen guten Rutsch ins Jahr 2013. Gruesse an B2H-Admin, gunner, easysurfer, y0sh, uberNewbster, BuntSpecht, Yakuza112, an alle Reverser und die sich noch auf diese Seite verirren. Gr33tz TheVamp";

//berschirift + mittig setzen
 int w,h;
TTF_SizeText(font, ubertext, &w, &h);
offset.x = (BREITE - w);
message = TTF_RenderText_Solid(font, ubertext , txt);

//Scrollingtext Voreinstellungen
SDL_Rect scrolloffer;
scrolloffer.y = offset.y + h + 30;
scrolloffer.x = 50;

//scrolltext = TTF_RenderText_Solid(font, jollitext, txt);
int count = 0;
char * scrollbuffer = (char*) malloc(19);
int scrolllange = strlen(blogtext);
     //window loop
     //hier wird nachher alles gerendert
     while(1)
     {

           SDL_BlitSurface(rahmen, NULL, screen, &offsetter);
           SDL_BlitSurface(message, NULL, screen, &offset);

           if(count >= scrolllange){count = 0;}

           strncpy(scrollbuffer ,&blogtext[count], 19);
           scrollbuffer[18] = '\0';
           //scrollbuffer[20] = '\0';
           scrolltext = TTF_RenderText_Solid(font, scrollbuffer, txt);
           printf("%s\n", scrollbuffer);
           count++;

           SDL_BlitSurface(scrolltext, NULL, screen, &scrolloffer);
           SDL_Flip(screen);
           SDL_Delay(250);
           //apply_surface(0,150, message, screen);
             //Tastaturabfrage mit SDL_Event
             SDL_Event event;
             //Wenn event eintritt
             while(SDL_PollEvent(&event))
             {
                    //event feststellen
                    switch(event.type)
                    {
                            //Tastendruck
                            case SDL_KEYDOWN:
                                  break;
                            //wenn taste gedrckt wurde
                            case SDL_KEYUP:
                                 //escape taste gedrueckt
                                 if(event.key.keysym.sym == SDLK_ESCAPE)
                                 {
                                     //Programm beenden
                                     return 0;
                                 }
                                 break;
                            //wenn demo zu ende (SDL_QUIT - event)
                            case SDL_QUIT:
                                 //beenden
                                 return 0;
                    }
             }
     }

      //Quit SDL
     TTF_Quit();
     Mix_CloseAudio();
     SDL_Quit();
     return 0;
 }

